<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model 
{

    protected $table = 'coupons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsToMany('App\Models\User', 'coupon_users', 'coupon_id', 'user_id');
    }

    public function store()
    {
        return $this->belongsTo('App\Models\Store');
    }

}